nsExtraComponents.nsToRacks      =   defineComponent({
    template: `
    <div id="to-racks" class="shadow-lg ns-box w-95vw md:w-3/5-screen lg:w-2/5-screen">
        <div class="p-2 border-b ns-box-header flex justify-between items-center">
            <h3 class="text-primary font-semibold">Transfer To Racks</h3>
            <div>
                <ns-close-button @click="popup.close()"></ns-close-button>
            </div>
        </div>
        <div class="p-2" v-if="loaded">
            <ns-field v-for="(field,index) of fields" :key="index" :field="field"></ns-field>
        </div>
        <div class="p-4 flex items-center justify-center" v-if="! loaded">
            <ns-spinner></ns-spinner>
        </div>
        <div class="border-t ns-box-footer p-2 flex justify-between">
            <div></div>
            <div>
                <ns-button @click="moveToRacks()" type="info">Move</ns-button>
            </div>
        </div>
    </div>
    `,
    props: [ 'popup', 'data' ],
    mounted() {
        this.fields     =   this.validation.createFields([
            {
                label: 'Unit',
                type: 'select',
                name: 'unit_id',
                options: [],
                description: 'Choose the unit you would like to move to racks.'
            }, {
                label: 'Rack',
                type: 'select',
                name: 'rack_id',
                validation: 'required',
                description: 'To which rack this is moved.'
            }, {
                label: 'Quantity',
                type: 'number',
                name: 'quantity',
                validation: 'required',
                description: 'Choose the quantity that should be processed.'
            }
        ]);
        this.loadUnits();
    },
    data() {
        return {
            loaded: false,
            validation: new FormValidation,
            fields: [],
            productUnits: [],
            racksList: [],
        }
    },
    methods: {
        moveToRacks() {
            const data          =   this.validation.extractFields( this.fields );
            const selectedUnit  =   this.productUnits.filter( unitQuantity => unitQuantity.unit_id === parseInt( data.unit_id ) );

            if ( selectedUnit.length > 0 ) {
                if ( selectedUnit[0].quantity >= parseFloat( data.quantity ) ) {
                    this.loaded         =   false;
                    const unitQuantity  =   selectedUnit[0];
                    
                    return nsHttpClient.post( `/api/racks-manager/move-to-racks/${unitQuantity.product_id}`, {
                            product_id  :   unitQuantity.product_id,
                            unit_id     :   data.unit_id,
                            quantity    :   data.quantity,
                            rack_id     :   data.rack_id,
                            unit_price  :   unitQuantity.sale_price
                        })
                        .subscribe( result => {
                            nsSnackBar.success( result.message ).subscribe();
                            this.loadUnits();
                        }, error => {
                            nsSnackBar.error( result.message ).subscribe();
                        })
                }

                return nsSnackBar.error( 'Unable to proceed there is not enough quantity' ).subscribe();
            }
        },

        loadUnits() {
            this.loaded     =   false;
            const value     =   this.popup.data;

            RxJS.forkJoin([
                    nsHttpClient.get( `/api/racks-manager/products/units/${this.data.row.id}` ),
                    nsHttpClient.get( `/api/racks-manager/racks` ),
                ])            
                .subscribe({
                    next: result => {
                        this.fields.forEach( field => {
                            if ( field.name === 'unit_id' ) {
                                this.productUnits   =   result[0];
                                field.options       =   result[0].map( option => {
                                    return {
                                        label: `${option.unit.name} (${option.quantity})`,
                                        value: option.unit.id
                                    }
                                });
                            } else if ( field.name === 'rack_id' ) {
                                this.racksList      =   result[1];
                                field.options       =   result[1].map( option => {
                                    return {
                                        label: `${option.name}`,
                                        value: option.id
                                    }
                                });
                            }
                        });
                        this.loaded     =   true;
                    },
                    error: ( error ) => {
                        nsSnackBar.error( error.message || 'Unexpected error occured', 'OK', { duration: false }).subscribe();
                    }
                })
        }
    }
});