const r={template:`
    <div class="flex flex-col" v-if="form">
        <div class="flex justify-between items-center">
            <label for="title" class="font-bold my-2 text-primary">{{ form.main.label || __( 'No title is provided' ) }}</label>
            <div for="title" class="text-sm my-2 text-gray-700">
                <a v-if="returnUrl" :href="returnUrl" class="rounded-full border border-gray-400 hover:bg-red-600 hover:text-white bg-white px-2 py-1">{{ __m( 'Go Back', 'NsSMS' ) }}</a>
            </div>
        </div>
        <div :class="form.main.disabled ? 'border-input-edge' : form.main.errors.length > 0 ? 'border-red-600' : 'border-input-edge'" class="flex border-2 rounded overflow-hidden">
            <!-- @blur="formValidation.checkField( form.main )" 
            @change="formValidation.checkField( form.main )"  -->
            <input v-model="form.main.value" 
                
                :disabled="form.main.disabled"
                type="text" 
                :class="form.main.disabled ? 'bg-input-disabled' : ''"
                class="flex-auto bg-input-background outline-none h-10 px-2 text-primary">
            <button :disabled="form.main.disabled" :class="form.main.disabled ? 'bg-input-disabled' : form.main.errors.length > 0 ? 'bg-red-500' : 'bg-info-tertiary'" @click="submit()" class="outline-none px-4 h-10 text-white border-l border-box-edge">{{ __m( 'Save', 'NsSMS' ) }}</button>
        </div>
        <p class="text-xs text-primary py-1" v-if="form.main.description && form.main.errors.length === 0">{{ form.main.description }}</p>
        <p class="text-xs py-1 text-error-tertiary" v-bind:key="index" v-for="(error, index) of form.main.errors">
            <span><slot name="error-required">{{ error.identifier }}</slot></span>
        </p>
        <div class="py-2">
            <div class="shadow ns-box mb-2">
                <div class="flex justify-between border-b border-box-edge">
                    <div class="p-2">
                        <h3 class="font-semibold">
                            {{ __( 'Run', 'NsSMS' ) }}
                            <span v-for="(rule, index) of activeValidRules" :key="index">
                                : {{ rule.label.replace( '"X"', rule.value ) }}
                            </span>
                        </h3>
                    </div>
                    <div class="flex">
                        <div class="pointer w-8 flex items-center justify-center border-box-edge border-l" @click="rulesOn = ! rulesOn">
                            <i v-if="rulesOn" class="las la-caret-down"></i>
                            <i v-if="! rulesOn" class="las la-caret-up"></i>
                        </div>
                    </div>
                </div>
                <div class="p-2 border-b border-box-edge" v-if="rulesOn">
                    <div class="flex flex-col">
                        <div class="flex flex-col w-full">
                            <div v-for="(rule, index) of activeValidRules" :key="index" class="items-center bg-blue-400 p-2 text-primary flex justify-between">
                                <span>{{ rule.label.replace( '"X"', rule.value ) }}</span>
                                <div class="flex justify-between items-center">
                                    <div>
                                        <ns-close-button @click="removeRule( rule.ruleName )"></ns-close-button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col w-full mb-2" v-if="activeValidRules.length === 0">
                            <div :key="index" v-for="(field, index) of rulesFields" class="mb-2">
                                <ns-field @change="handleFieldChange( $event )" :field="field" ></ns-field>
                            </div>
                            <div class="flex justify-end">
                                <ns-button @click="addRule()" type="info">{{ __m( 'Add Rule', 'NsSMS' ) }}</ns-button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="shadow ns-box mb-2">
                <div class="p-2 border-b border-box-edge">
                    <h3 class="font-semibold">{{ form.tabs.general.label }}</h3>
                </div>
                <div class="p-2 ns-box-body">
                    <div class="flex flex-col w-full mb-2">
                        <div :key="index" v-for="(field, index) of form.tabs.general.fields" class="mb-2">
                            <ns-field :field="field" ></ns-field>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    `,data(){return{__,__m,form:null,formValidation:new FormValidation,rulesOn:!1,rulesFields:[],activeRules:{},activeValidRules:[],links:SMSLinks,campaign:SMSCampaign===void 0?!1:SMSCampaign}},mounted(){this.form=this.formValidation.createForm(SMSForm),this.__m=__m,this.__=__,this.rulesFields=this.formValidation.createFields([{label:__m("Rule"),type:"select",options:SMSRules,name:"rule",value:"OnCompleteSale",validation:"required",description:__m("Select the rule that should trigger this campaign","NsSMS")},{label:__m("Value"),type:"number",name:"value",value:1,validation:"required",description:__m('Set the value that apply to the above rule. Applicable to rules having "X".',"NsSMS")}]),this.campaign&&(this.campaign.rules.forEach(i=>{this.activeRules[i.condition]=i.value}),console.log(this.activeRules))},watch:{activeRules:{deep:!0,handler(){const i=[];for(let e in this.activeRules)if(SMSRules[e]!==void 0){const s=SMSRules[e];i.push({label:s.label,value:this.activeRules[e],ruleName:e})}this.activeValidRules=i,console.log("refreshed")}}},methods:{addRule(){if(this.activeRules=new Object,!this.formValidation.validateFields(this.rulesFields))return nsSnackBar.error(__m("The rule is not valid","NsSMS")).subscribe();const e=this.formValidation.extractFields(this.rulesFields);this.activeRules[e.rule]=e.value>=0?e.value:0},handleFieldChange(i){const e=this.rulesFields.filter(l=>l.name==="rule");Object.keys(SMSRules).filter(l=>["OnSaleXBeforeDue","OnProcurementXAfterStocked","OnXBeforeBirthDay","OnXDayAfterIdle"].includes(l)).includes(e[0].value)?this.rulesFields[1].disabled=!1:this.rulesFields[1].disabled=!0,console.log(this.rulesFields)},submit(){if(!this.formValidation.validateForm(this.form))return nsSnackBar.error(__m("Unable to proceed the form is not valid.","NsSMS")).subscribe();const e=this.formValidation.extractForm(this.form);e.rules=new Object;for(let l in this.activeRules)e.rules[l]=this.activeRules[l];const s=this.campaign?"put":"post";nsHttpClient[s](this.campaign?this.links.put.replace("{id}",this.campaign.id):this.links.post,e).subscribe({next:l=>{nsSnackBar.success(l.message,"OK",{duration:3e3}).subscribe(),setTimeout(()=>document.location=this.links.list,1e3)},error:l=>nsSnackBar.error(l.message||__m("An unexpected error occured.","NsSMS")).subscribe()})},removeRule(i){delete this.activeRules[i]}}};nsExtraComponents.SmsForm=r;
